/*
 * DomainVector.java
 *
 * 
 */
 package DisCSP.CSP;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


import java.util.Vector;
import DisCSP.Exception.EmptyDomainException;
import DisCSP.Exception.OutDomainException;

class DomainVector extends Vector
{

 	/** Costruttore di LexerException
     * 
     * @param ecc il messaggio di errore relativo all'eccezione
     * 
     */
     public DomainVector()
	{
		super();
	}

 	/** Costruttore di DomainVector
     * 
     * @param v l'elemento del dominio
     * 
     */
	public DomainVector(int v)
	{
		super();
		int[] app = doArrS(v);
		add(0,app);
	}

 	/** Costruttore di DomainVector
     * 
     * @param min l'estremo inferiore del dominio
     * @param max l'estremo superiore del dominio
     * 
     */	
	
	public DomainVector(int min, int max)
	{
		super();
		int[] app = doArrM(min, max);
		add(0,app);
	}
	
	 /**  Aggiunge un intero al dominio
     * 
	 * @param v il numero intero
     * 
     */	
	public  void addValue(int v)
	{
		try
		{
			//valore presente
			if(isPresent(v)) return;
			
			//dominio vuoto
			if(isEmpty())
			{	
				add(doArrS(v));
				return;
			}
			
			int[] app=new int [2];
			
			//diventa il nuovo min
			if(v<getMinValue())
			{	
				//amplia il primo dom
				if(v == getMinValue()-1)
				{
					app= arrayAt(0);
					app[0]=v;
					setElementAt(app,0);
				}
				// indipendente
				else
				{
					app=doArrS(v);
					insertElementAt(app,0);
				}
				return;
			}
			
			//diventa il nuovo max
			if(v>getMaxValue())
			{	
				//amplia l'ultimo dom
				if(v == getMaxValue()+1)
				{
					int last=size()-1;
					app= arrayAt(last);
					app[1]=v;
					setElementAt(app,last);
				}
				// indipendente
				else
				{
					app=doArrS(v);
					add(app);
				}
				
				return;			
			}
			
			//cambia gli estremi di un dominio

			int[] prec=new int [2];
			int[] succ=new int [2];
			
			for(int i=0;i<size()-1;i++)
			{
				prec = arrayAt(i);
				succ = arrayAt(i+1);
				
				//controllo se ho trovato i due intervalli in cui inserirmi
				if(v>prec[1] && v<succ[0])
				{
					//unifica due intervalli
					if(v==prec[1]+1 && v==succ[0]-1)
					{
						app[0]=prec[0];
						app[1]=succ[1];
						remove(i);
						remove(i);
						insertElementAt(app,i);
						return;
					}
					
					//amplia un intervallo (prec) senza unificarlo al successivo
					if(v==prec[1]+1)
					{
						app= prec;
						app[1]=v;
						setElementAt(app,i);
						return;
					}
					
					//amplia un intervallo (succ) senza unificarlo al precedente
					if(v==succ[0]-1)
					{
						app= succ;
						app[0]=v;
						setElementAt(app,i+1);
						return;
					}
					
					//si inserisce tra due intervalli
					insertElementAt(doArrS(v),i+1);
					return;
				}
			}
			
		}
		catch (Exception e)
		{
		}
		
		
	}

	 /** Rimuove un valore dal dominio
     * 
	 * @param v l'intero da rimuovere
     * 
     */		
	public  void removeValue(int v)
	{
		try
		{
			//dominio vuoto
			if(isEmpty()) return;
			//valore non presente
			if(!isPresent(v)) return;

			int[] app=new int [2];
			
			// il min
			if(v==getMinValue())
			{	
				app= arrayAt(0);
				
				if(app[0]==app[1])
				{
					remove(app);
					return;
				}
				else
				{
					app[0]=v+1;
					setElementAt(app,0);
					return;
				}
				
			}
			
			// il max
			if(v==getMaxValue())
			{	
				int last=size()-1;
				app= arrayAt(last);
				if(app[0]==app[1])
				{
					remove(app);
					return;
				}
				else
				{
					app[1]=v-1;
					setElementAt(app,last);
					return;	
				}
			}
							
			//cambia un dominio
			for(int i=0;i<size();i++)
			{
				app = arrayAt(i);
				
				if(v==app[0] && v==app[1])
				{
					remove(app);
					return;
				}
				
				//controllo se ho trovato il dominio che contiene il valore da rimuovere
				if( v>=app[0] && v<=app[1])
				{
					// l'estremo inferiore dell'intervallo
					if(v==app[0])
					{
						app[0]=v+1;
						setElementAt(app,i);
						return;
					}
					
					// l'estremo superiore dell'intervallo
					if(v==app[1])
					{
						app[1]=v-1;
						setElementAt(app,i);
						return;
					}
					
					//divide in due l'intervallo
					int[] prec=new int [2];
					int[] succ=new int [2];
					prec[0]=app[0];
					prec[1]=v-1;
					succ[0]=v+1;
					succ[1]=app[1];
					
					insertElementAt(prec,i);
					insertElementAt(succ,i+1);
					remove(app);
					return;
				}
			}
		
		}
		catch (Exception e)
		{
		}	
	}

	 /** Restituisce l'i-esimo valore del dominio
     * 
	 * @param i l'indice
     * @return l'i-esimo valore del dominio
     * 
     */	
	public  int valueAt(int index) throws OutDomainException
	{
		if(index<0||index>cardinality()-1)
			throw new OutDomainException();
			
		int  pos=0;
		
		for(int i=0;i<size();i++)
		{
			int [] app= arrayAt(i);
			for(int j=app[0];j<=app[1];j++)
			{
				if(pos==index) return j;
				pos++; 
			}
		}
		
		throw new OutDomainException();
	}
	
	 /** Aggiunge al dominio un intervallo di cui sono specificati l'estremo inferiore e l'estremo superiore
     * 
	 * @param min l'estremo inferiore
	 * @param max l'estremo superiore
     * 
     */
	
	public void addInterval(int min, int max)
	{
		try
		{
			if(isEmpty())
			{	
				add(doArrM(min,max));
				return;
			}
			if(max<getMinValue())
			{	
				insertElementAt(doArrM(min,max),0);
				return;
			}
			if(min>getMaxValue())
			{	
				add(doArrM(min,max));
				return;
			}
			if(max==getMinValue())
			{	
				int app=arrayAt(0)[1];
				insertElementAt(doArrM(min,app),0);
				return;
			}
			if(min==getMaxValue())
			{	
				int last=size()-1;
				int app=arrayAt(last)[0];
				insertElementAt(doArrM(app,max),last);
				return;
			}
			for(int i=min;i<=max;i++)
			{
				addValue(i);
			}			
		}
		catch (Exception e)
		{
		}
		
		

		
	}
	
	/** Stampa il dominio
	 *
     * @return una stringa che rappresenta il dominio
     * 
     */			
	public  String print()
	{
		String dom="[";
		
		int[] app;
		
		for(int i=0;i<size();i++)
		{
			if(i==size()-1)
			{
				app= arrayAt(i);
				if(app[0]==app[1])
					dom+=app[0];
				else if(app[0]==(app[1]-1))
					dom+=app[0]+","+app[1];
				else
					dom+=app[0]+".."+app[1];
				
			}

			else
			{
				app= arrayAt(i);
				if(app[0]==app[1])
					dom+=app[0]+",";
				else if(app[0]==(app[1]-1))
					dom+=app[0]+","+app[1]+",";
				else
					dom+=app[0]+".."+app[1]+",";
				
			}
		}
		
		dom+="]";
		return dom;
	}

	 /**  Controlla se un certo intero  presente nel dominio
     * 
	 * @param val l'intero
     * @return true se val  presente nel dominio, false altrimenti
     * 
     */
		
	public  boolean isPresent(int val)
	{
		if(isEmpty())
			return false;
		int[] app;
		for(int i=0;i<size();i++)
		{
			app = arrayAt(i);
			if(val>=app[0] && val<=app[1])
				return true;
		}
		return false; 
	}

	 /**  Restituisce la cardinalit del dominio
     * 
     * @return la cardinalit del dominio
     * 
     */	
	public  int cardinality()
	{
		int c=0;
		int[] app;
		
		for(int i=0;i<size();i++)
		{
			app= arrayAt(i);
			c+= app[1]- app[0] +1;
		}
		return c;
	}
		
	 /**  Restituisce il valore pi piccolo appartenente al dominio
     * 
     * @return il valore pi piccolo appartenente al dominio
     * @throws EmptyDomainException
     * 
     */

	public int getMinValue() throws EmptyDomainException
	{
		if(! isEmpty())
			return ((int[]) firstElement())[0];
		else throw new EmptyDomainException();
			
	}
	
	 /**  Restituisce il valore pi grande appartenente al dominio
     * 
     * @return il valore pi grande appartenente al dominio
     * @throws EmptyDomainException
     * 
     */


	public  int getMaxValue() throws EmptyDomainException
	{
		if(! isEmpty())
			return ((int[]) lastElement())[1];
		else throw new EmptyDomainException();
	}
	
	private int[] doArrS(int v)
	{
		int[] arr= new int[2];
		arr[0]=v;
		arr[1]=v;
		return arr;
	}
	
	private int[] doArrM(int min, int max)
	{
		int[] arr= new int[2];
		arr[0]=min;
		arr[1]=max;
		return arr;
	}
	
	private int[] arrayAt(int i)
	{
		return (int[]) elementAt(i);
	}

}